#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "global.h"
#include "evolve.h"
#include "display.h"
#include "display.h"
#include "utils.h"
#include "routine.h"

DISPLAY *display=NULL;
long display_free=0;
long display_size=0;

void init_display(void)
{
display_size=20;
display_free=0;
display=do_alloc(display_size,sizeof(DISPLAY));
}

void reset_display(void)
{
long i;
for(i=display_free-1;i>=0;i--)
	delete_display(i);
}

void delete_display(long i)
{
long k;
display_free--;
free(display[i].name);
free(display[i].comment);
free(display[i].type);
free(display[i].color1);
free(display[i].color2);
free(display[i].color3);
for(k=i;k<display_free;k++)memcpy(&(display[k]),&(display[k+1]),sizeof(DISPLAY));
}

void expand_display(void)
{
long i;
DISPLAY *r;

r=do_alloc(display_size*2,sizeof(DISPLAY));
for(i=0;i<display_free;i++)memcpy(&r[i],&display[i],sizeof(DISPLAY));
free(display);
display=r;
display_size=display_size*2;
}

DISPLAY * add_new_display(char *name)
{
DISPLAY *r;
if(display_free+1>=display_size)expand_display();
r=&(display[display_free]);
display_free++;
r->name=strdup(name);
r->comment=strdup("");
r->type=strdup("");
r->color1=strdup("");
r->color2=strdup("");
r->color3=strdup("");
r->routine_type=-1;
r->routine_index1=-1;
r->routine_index2=-1;
r->routine_index3=-1;
return r;
}


long get_display_index(char *name)
{
long i;
for(i=0;i<display_free;i++){
	if(!strcmp(display[i].name,name))return i;
	}
return -1;
}

DISPLAY *get_display(long index)
{
if(index<0)return NULL;
if(index>=display_free)return NULL;
return &(display[index]);
}

char *get_display_name(long index)
{
DISPLAY *r;

r=get_display(index);
if(r==NULL)return "display_unknown";
return r->name;
}

void dump_display(FILE *fout,DISPLAY *r)
{
if(r==NULL)return;
fprintf(fout,"view \"%s\"\n",r->name);
fprintf(fout,"\tcomment \"%s\"\n",r->comment);
fprintf(fout,"\ttype \"%s\"\n",r->type);
fprintf(fout,"\tcolor1 \"%s\"\n",r->color1);
fprintf(fout,"\tcolor2 \"%s\"\n",r->color2);
fprintf(fout,"\tcolor3 \"%s\"\n",r->color3);
fprintf(fout,"end\n");
}

void dump_displays(FILE *fout)
{
long i;

for(i=0;i<display_free;i++)
		dump_display(fout,&(display[i]));
}

char *code_string="xzoceabdfghijklmnpqrstuvwy";
int  code_string_length=2;

char code_value(u64 a)
{
u64 b;
b=((unsigned) (a ))% code_string_length;
if(b<0)b=0;
if(b>=code_string_length)b=code_string_length-1;
return code_string[b];
}

/* this uses only type and color1 parameters */
void display_field(FILE *fout,FIELD *f,DISPLAY *d)
{
long i,j;
char cap;
u64 result;
code_string_length=strlen(code_string);
set_current_field(f);
fprintf(fout,"display field=\"%s\" view=\"%s\" time=%lld\n",f->name,d->name,get_time());
for(j=0;j<f->y_size;j++){
	fprintf(fout,"\t");
	for(i=0;i<f->x_size;i++)
		{
		if(f->agent[i][j]==NULL)fprintf(fout,"+");
			else {
			set_current_agent(i,j);
			if(evaluate_routine(d->routine_type,&result)<0)printf(".");
				else {
				cap=('A'-'a')*(result & 1);
				if(evaluate_routine(d->routine_index1,&result)<0)printf("*");
					else 
  					fprintf(fout,"%c",cap+code_value(result)); 
				}
			}
		}
	fprintf(fout,"\n");
	}
fprintf(fout,"end\n");
}

void display_fields(FILE *fout)
{
long i,k;
FIELD *f;
DISPLAY *d;
for(i=0;i<num_fields();i++){
	f=get_field(i);
	if(f!=NULL){
		for(k=0;k<display_free;k++){
			d=get_display(k);
			if(d!=NULL)
				display_field(fout,f,d);
			}
		}
	}
}

long num_display(void)
{
return display_free;
}

